<?php

  //パスワードをチェック
  function checkpassword($password) {
    $hash_file = "../data/password";
    //adminディレクトリからのパスになっているため、例えば直下からはcheckpassword関数は呼び出せない
    $hash = file_get_contents($hash_file);
    if ($hash) {
      return password_verify($password, $hash);
    } else {
      //パスワードファイルが存在しなかったら全部通す
      return true;
    }
  }

  //指定されたパスからjsonデータを出力
  function getjsondata($file) {
  if (isset($file) && !($file=="")) {
      $jsondata = file_get_contents($file);
      $jsondata = mb_convert_encoding($jsondata, 'UTF8', 'ASCII,JIS,UTF-8,EUC-JP,SJIS-WIN');
      $jsondata = json_decode($jsondata, true);
      return $jsondata;
    }
  }

  //指定されたパスにjsonデータを書き込み
  function savejsondata($file, $array) {
  if (isset($file, $array) && !($file=="") && !($array=="")) {
      $result = json_encode($array, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
      return file_put_contents($file, $result, LOCK_EX);
    }
  }

  //テキストエンコード
  function textencode($text) {
    if (isset($text) && !($text=="")) {
      $list = array("丹羽","にわ","ニワ","政雄","まさお","マサオ");
      return str_replace($list, "うんこ", $text);
    } else {
      return "";
    }
  }

  //メール
  function sendmail($subject, $body, $setting_path) {
  if (isset($subject, $body) && !($subject=="") && !($body=="")) {
    mb_language("Japanese");
    mb_internal_encoding("UTF-8");
    //設定値を取得
    //adminディレクトリと直下の両方から呼び出す可能性があるため、setting.jsonのパスは引数から
    $jsondata = getjsondata($setting_path);
    //Toとfromは特定の一箇所にする設定
    if ($jsondata["mailfrom"]) {
      $mailfrom = $jsondata["mailfrom"];
    } else {
      $mailfrom = "sendonly@shindaicfc.com";
      //存在しないアドレスにしといた方がメールサーバー圧迫しない気がする
    }
    //送信先としてBCCを指定
    $bcc = $jsondata["bcc"];
    $bcc_list = "";
    foreach ($bcc as $value) {
      $bcc_list .= ",".$value;
    }
    $from_name = mb_encode_mimeheader("CFC機材管理システム");
    //ヘッダー作成
    $header = '';
    $header .= "Content-Type: text/plain \r\n";
    $header .= "MIME-Version: 1.0\r\n";
    $header .= "Content-Transfer-Encoding: 7bit\r\n";
    $header .= "Content-Type: text/plain; charset=ISO-2022-JP\r\n";
    $header .= "Return-Path: " . $mailfrom . " \r\n";
    $header .= "From: " . $from_name . "<" . $mailfrom . ">\r\n";
    $header .= "Sender: " . $from_name . "<" . $mailfrom . ">\r\n";
    $header .= "Reply-To: " . $mailfrom . " \r\n";
    $header .= "Organization: " . $from_name . "\r\n";
    $header .= "Bcc: " . $bcc_list . "\r\n";;
    $header .= "X-Sender: " . $mailfrom . " \r\n";
    $header .= "X-Priority: 3 \r\n";
    mb_send_mail($mailfrom, $subject, $body, $header);
    }
  }

?>
